define([
    'backbone',
    'Layout',
    'modules/community-care-request/new-appointment-request-question/preferred-provider/preferences/preferred-provider-section-view', // eslint-disable-line max-len
], function(
    Backbone,
    Layout,
    PrimaryCareSectionView
) {
    'use strict';

    describe('Preferred Provider Section', function() {
        var view;
        var model;
        var collection;
        var $view;
        var layout;

        beforeEach(function() {
            layout = new Layout();
            layout.render();
            spyOn(PrimaryCareSectionView.prototype, 'getOfficeHoursNeeded').and.callThrough();

            model = new Backbone.Model({steps: [5], officeHours: []});

            view = new PrimaryCareSectionView({
                model: model,
            });
            layout.showChildView('content', view);
            $view = view.$el;
        });


        afterEach(function () {
            layout.getRegion('content').empty();
        });

        it('shows a primary care form with options', function() {
            expect(view.collection.get('primaryCity').get('type')).toEqual('text');
            expect(view.collection.get('primaryState').get('type')).toEqual('select');
            expect(view.collection.get('primaryZipCode').get('type')).toEqual('text');
            expect(view.collection.get('primaryPreferredMiles').get('type')).toEqual('radio');
            expect(view.collection.get('preferredLanguageSpoken').get('type')).toEqual('select');
            expect(view.collection.get('officeHours').get('type')).toEqual('checkbox');
        });


        it('has the heading Provider Preference', function() {
            expect($view.find('legend:eq(0)').text()).toEqual('Preferred Location');
        });
        it('has the heading How many miles away from this location are you willing to travel?', function() {
            expect($view.find('legend:eq(1)').text()).toEqual('* How many miles away from this location are you willing to travel?');
        });
        it('has the heading Office Hours (check all that apply)', function() {
            expect($view.find('legend:eq(2)').text()).toEqual('* Office Hours (check all that apply)');
        });

        describe('getOfficeHours when it is invoked', function() {
            it('getOfficeHours sets all values to selected true when exists on wizard model', function() {
                model = new Backbone.Model({steps: [5], officeHours: ['Weekdays', 'Weekends', 'Evenings']});
                view = new PrimaryCareSectionView({model: model, collection: collection});
                layout.showChildView('content', view);
                expect(view.getOfficeHoursNeeded).toHaveBeenCalled();
                view.collection.get('officeHours').get('values')
                    .forEach(function(valueObj) {
                        expect(valueObj.selected).toBe(true);
                    });
            });

            it('getOfficeHours sets only defaulted vaulues when exists on wizard model', function() {
                model = new Backbone.Model({steps: [5], officeHours: ['Weekdays', 'Weekends']});
                view = new PrimaryCareSectionView({model: model});
                layout.showChildView('content', view);
                expect(view.getOfficeHoursNeeded).toHaveBeenCalled();
                view.collection.get('officeHours').get('values')
                    .forEach(function(valueObj) {
                        if (valueObj.value === 'Weekdays' || valueObj.value === 'Weekends') {
                            expect(valueObj.selected).toBe(true);
                        } else {
                            expect(valueObj.selected).toBe(false);
                        }
                    });
            });

            it('getOfficeHours sets only defaulted values when exists on wizard model', function() {
                model = new Backbone.Model({steps: [5]});
                view = new PrimaryCareSectionView({model: model});
                layout.showChildView('content', view);
                expect(view.getOfficeHoursNeeded).toHaveBeenCalled();
                view.collection.get('officeHours').get('values')
                    .forEach(function(valueObj) {
                        expect(valueObj.selected).toBe(false);
                    });
            });
        });

        describe('updateFDNS   el when its invoked', function() {
            var officeHoursModel1;
            var officeHoursModel2;
            var officeHoursModel3;
            it('updates wizard model when the form collection is changed with two selected', function() {
                model = new Backbone.Model({steps: [5], officeHours: ['Weekdays']});
                view = new PrimaryCareSectionView({model: model});
                layout.showChildView('content', view);
                view = new PrimaryCareSectionView({model: model});
                officeHoursModel1 = new Backbone.Model({
                    id: 'officeHours',
                    value: 'Weekends',
                    selected: true,
                });
                officeHoursModel2 = new Backbone.Model({
                    id: 'officeHours',
                    value: 'Evenings',
                    selected: true,
                });
                officeHoursModel3 = new Backbone.Model({
                    id: 'officeHours',
                    value: 'Weekdays',
                    selected: false,
                });
                layout.showChildView('content', view);
                view.updateFDNS   el(officeHoursModel1);
                view.updateFDNS   el(officeHoursModel2);
                view.updateFDNS   el(officeHoursModel3);
                expect(view.model.get('officeHours')).toEqual(['Weekends', 'Evenings']);
            });
            it('updates wizard model when the form collection is changed with one selected value', function() {
                // set new values to select
                model = new Backbone.Model({steps: [5], officeHours: ['Weekends', 'Weekdays']});
                view = new PrimaryCareSectionView({model: model});
                officeHoursModel1 = new Backbone.Model({
                    id: 'officeHours',
                    value: 'Weekdays',
                    selected: false,
                });
                layout.showChildView('content', view);
                view.updateFDNS   el(officeHoursModel1);
                expect(view.model.get('officeHours')).toEqual(['Weekends']);
            });
        });
    });
});
